﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ObiegowkiSzczegoly.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.ObiegowkiSzczegoly" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Obiegówka</title>
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />

    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>

    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>

    <script src="../jquery/jquery.corner.js" type="text/javascript"></script>

    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>

    <style type="text/css">
        body {
            margin-top: 0px;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
            color: Black;
        }

        .divKomentarz {
            border-top-color: #8C4200;
            border-top-width: 1px;
            border-top-style: solid;
            padding: 4px;
        }

        .divImieData {
            width: 100%;
            height: 20px;
        }

        .divImieNazwisko {
            border-color: orange;
            border-width: 1px;
            border-style: solid;
            font-size: 10px;
            background-color: orange;
            margin-left: 20px;
            margin-top: 6px;
            min-width: 100px;
            float: left;
            padding: 1px 10px 1px 10px;
        }

        .divData {
            border-color: orange;
            border-width: 1px;
            border-style: solid;
            font-size: 10px;
            background-color: orange;
            margin-right: 20px;
            margin-top: 6px;
            width: 105px;
            float: right;
            padding: 1px 5px 1px 5px;
        }

        .spanKomentarz {
            cursor: pointer;
            text-decoration: underline;
        }

            .spanKomentarz:hover {
                cursor: pointer;
                text-decoration: underline;
                color: orange;
            }

        .divTresc {
            font-family: Verdana, Tahoma, Arial;
            border-color: orange;
            border-width: 1px;
            border-style: solid;
            padding: 10px 4px 4px 4px;
            margin-top: -6px;
            background-color: white;
            font-size: 12px;
            word-wrap: break-word;
        }

        .preTresc {
            margin-top: 4px;
            margin-bottom: 4px;
        }

        .divPrzyciskDodaj {
            margin-left: 0px;
            margin-right: 0px;
            width: auto;
            height: 30px;
            display: block;
        }

        #btnPowrot {
            float: right;
            font-size: 10pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
        }

        .buttonDodaj {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
        }

        .buttonZapisz {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
        }

        .buttonAnuluj {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
        }

        .buttonTak {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
        }

        .buttonNie {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
        }

        .buttonRozpRozlicz {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
            width: 150px;
        }

        .buttonZatwierdz {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
            width: 150px;
        }

        .buttonIST {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
            width: 140px;
        }

        .buttonISTLink {
            float: right;
            font-size: 8pt;
            font-family: Verdana, Tahoma, Arial;
            font-style: normal;
            font-weight: normal;
            width: 140px;
        }

        .btnAkceptujacy {
            font-size: 8pt;
            padding-top: 0px;
            padding-bottom: 0px;
            padding-left: 1px;
            padding-right: 1px;
        }

        .divDodajKomentarz {
            margin-top: 10px;
            margin-left: 0px;
            margin-right: 0px;
            width: auto;
            height: 100px;
            display: none;
        }

        .divTextareaWrapper {
            padding-right: 6px;
        }

        .textareaStyle {
            margin-left: 0px;
            margin-right: 0px;
            width: 100%;
        }

        .tableObiegowka {
            width: 100%;
            border-bottom-color: #8C4200;
            border-bottom-width: 1px;
            border-bottom-style: solid;
            border-left-color: #8C4200;
            border-left-width: 1px;
            border-left-style: solid;
        }

            .tableObiegowka td {
                border-top-color: #8C4200;
                border-top-width: 1px;
                border-top-style: solid;
                border-right-color: #8C4200;
                border-right-width: 1px;
                border-right-style: solid;
                padding: 4px;
                font-size: 12px;
            }

        .tableHeader {
            background-color: #8C4200;
            color: White;
            vertical-align: middle;
            text-align: center;
            padding: 4px;
            font-size: 11px;
            font-weight: normal;
            border-top-color: orange;
            border-top-width: 1px;
            border-top-style: solid;
            border-right-color: orange;
            border-right-width: 1px;
            border-right-style: solid;
        }

        .tableRow {
            background-color: #DCDCDC;
        }

        .tableRowAlt {
            background-color: whitesmoke;
        }

        .tableRowKomentarz {
            background-color: #DCDCDC;
        }

        .tableRowKomentarzAlt {
            background-color: whitesmoke;
        }
    </style>
    <script type="text/javascript">
        function ZwinRozwinKomentarz(divName) {
            if (document.getElementById(divName).style.display == 'block') {
                document.getElementById(divName).style.display = 'none';
            }
            else {
                document.getElementById(divName).style.display = 'block';
            }
        }

        function PokazZapisKomentarza(divNameNumer) {
            document.getElementById('divDodajKomentarz' + divNameNumer).style.display = 'block';
            document.getElementById('divPrzycisDodaj' + divNameNumer).style.display = 'none';
        }

        function UkryjZapisKomentarza(divNameNumer) {
            document.getElementById('divDodajKomentarz' + divNameNumer).style.display = 'none';
            document.getElementById('divPrzycisDodaj' + divNameNumer).style.display = 'block';
        }

        $(function () {

            $("#btnPowrot").button({ icons: { primary: 'ui-icon-arrowreturnthick-1-w' } });
            $(".buttonDodaj").button({ icons: { primary: 'ui-icon-comment' } });
            $(".buttonZapisz").button({ icons: { primary: 'ui-icon-disk' } });
            $(".buttonAnuluj").button({ icons: { primary: 'ui-icon-cancel' } });
            $(".buttonRozpRozlicz").button({ icons: { primary: 'ui-icon-pencil' } });
            $(".buttonZatwierdz").button({ icons: { primary: 'ui-icon-check' } });
            $(".buttonTak").button({ icons: { primary: 'ui-icon-check' } });
            $(".buttonNie").button({ icons: { primary: 'ui-icon-cancel' } });
            $(".buttonIST").button({ icons: { primary: 'ui-icon-refresh' } });
            $(".buttonISTLink").button({ icons: { primary: 'ui-icon-extlink' } });
            $(".btnAkceptujacy").button({ icons: { primary: 'ui-icon-person' }, text: false, label: "Osoby mogące zatwierdzić sekcję" });
            $("#btnZamknijOknoOk").button({ icons: { primary: 'ui-icon-close' } });
            $(".divTresc").corner("8px");
            $(".divImieNazwisko").corner("4px");
            $(".divData").corner("4px");

            $(".dialog-form").dialog({
                autoOpen: false,
                height: 170,
                width: 400,
                modal: true,
                position: "top",
                resizable: false

            });

            $("#dialog-form-ok").dialog({
                autoOpen: false,
                height: 110,
                width: 300,
                modal: true,
                position: "center",
                resizable: false

            });
        });

        function OtworzOkienko(nr) {
            $("#dialog-form" + nr).dialog("open");
        }

        function ZamknijOkienko(nr) {
            $("#dialog-form" + nr).dialog("close");
        }

        function ZamknijOkienkoAkceptujacy(nr) {
            document.getElementById("dialog-form-akceptujacy" + nr).style.display = "none";
        }

        function OtworzOkienkoOk() {
            $("#dialog-form-ok").dialog("open");
        }

        function ZamknijOkienkoOk() {
            $("#dialog-form-ok").dialog("close");
        }
    </script>
</head>
<body runat="server" id="body">
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server">
        </asp:ScriptManager>
        <script type="text/javascript">

            //On UpdatePanel Refresh
            //po update updatePanel gubione jest jquery na zwracanym fragmencie
            //Sys.WebForms.PageRequestManager.getInstance() musi byc wywołane po ScriptManager
            var prm = Sys.WebForms.PageRequestManager.getInstance();
            if (prm != null) {
                prm.add_endRequest(function (sender, e) {
                    if (sender._postBackSettings.panelsToUpdate != null) {
                        $(".btnAkceptujacy").button({ icons: { primary: 'ui-icon-person' }, text: false, label: "Osoby mogące zatwierdzić sekcję" });
                    }
                });
            };
        </script>
        <div>
            <table style="margin-top: 0px; border-width: 0px; width: 100%;" cellpadding="0px" cellspacing="0px">
                <tr>
                    <td colspan="2">
                        <asp:Label ID="lblError" runat="server"></asp:Label></td>
                </tr>
                <tr>
                    <td style="font-size: 20px; font-weight: bold">
                        <asp:Label ID="lblObiegowka" runat="server">Obiegówka</asp:Label>
                    </td>
                    <td style="font-size: 16px;" valign="bottom">
                        <div style="float: left;">
                            <span style="font-size: 11px;">Data rozwiązania/zakończenia:</span><br />
                            <asp:Label ID="lblDataZakonczenia" runat="server"></asp:Label>
                        </div>
                        <div style="float: right;">
                            <asp:LinkButton ID="btnPowrot" runat="server" OnClick="btnPowrot_Click">Powrót</asp:LinkButton>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td style="font-size: 16px;" valign="bottom">
                        <span style="font-size: 11px;">Jednostka:</span><br />
                        <asp:Label ID="lblJednostka" runat="server"></asp:Label>
                    </td>
                    <td style="font-size: 16px;" valign="bottom">
                        <span style="font-size: 11px;">Stanowisko:</span><br />
                        <asp:Label ID="lblStanowisko" runat="server"></asp:Label>
                    </td>
                </tr>
            </table>
        </div>
        <asp:PlaceHolder ID="placeHolder" runat="server"></asp:PlaceHolder>
        <asp:PlaceHolder ID="phOkienka" runat="server"></asp:PlaceHolder>
        
        <!-- Okienko dialogu ok -->
        <div id="dialog-form-ok" style="display:none;" title="Aktualizacja zakończona">
            <div style="width: 100%;">
                <span>Aktualizacja danych z iST przebiegła pomyślnie.</span>
            </div>
            <div style="height: 20px;">
                &nbsp;
            </div>
            <div>
                <div style="float: right;">
                    <a id="btnZamknijOknoOk" href="javascript:ZamknijOkienkoOk()">Zamknij</a>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
